/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.animation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;
import tiled.mapeditor.animation.AnimationDialog;

class SpriteCanvas
extends JPanel {
    private AnimationDialog owner;
    private Image buffer;
    private Dimension osd;

    SpriteCanvas(AnimationDialog o) {
        this.owner = o;
    }

    private static void paintBackground(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int side = 10;
        int startX = clip.x / side;
        int startY = clip.y / side;
        int endX = (clip.x + clip.width) / side + 1;
        int endY = (clip.y + clip.height) / side + 1;
        g.setColor(Color.WHITE);
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(Color.LIGHT_GRAY);
        for (int y = startY; y < endY; ++y) {
            for (int x = startX; x < endX; ++x) {
                if ((y + x) % 2 != 1) continue;
                g.fillRect(x * side, y * side, side, side);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.owner != null) {
            Dimension d = this.getSize();
            if (this.buffer == null) {
                this.osd = d;
                this.buffer = this.createImage(d.width, d.height);
            }
            if (d.width != this.osd.width || d.height != this.osd.height) {
                this.osd = d;
                this.buffer = this.createImage(d.width, d.height);
            }
            SpriteCanvas.paintBackground(g);
            if (this.buffer != null) {
                Graphics osg = this.buffer.getGraphics();
                this.owner.paintSprite(osg);
                g.drawImage(this.buffer, 0, 0, null);
            } else {
                this.owner.paintSprite(g);
            }
        }
    }
}

